<?php
namespace wcf\system\option\user;
use wcf\data\user\option\UserOption;
use wcf\data\user\User;
use wcf\util\StringUtil;

/**
 * @author		Wörki
 * @copyright	2018 OMSI-WebDisk.de
 * @package		de.omsi-webdisk.wcf.TMP_profile
 */
class TMPUserOptionOutput implements IUserOptionOutput {
/**
 * @see wcf\system\option\user\IUserOptionOutput::getOutput()
 */
public function getOutput(User $user, UserOption $option, $value) {
		if (empty($value)) return '';
		
		$value = trim($value);
        $value = str_ireplace("https://truckersmp.com/user/", "", $value);
        $link = 'https://truckersmp.com/user/' . $value;

		$link = StringUtil::encodeHTML($link);
		$value = StringUtil::encodeHTML($value);

		return '<a href="'.$link.'" class="externalURL"'.(EXTERNAL_LINK_REL_NOFOLLOW ? ' rel="nofollow noopener noreferrer"' : ' rel="noopener noreferrer"').(EXTERNAL_LINK_TARGET_BLANK ? ' target="_blank"' : '').'>'.$link.'</a>';
	}
}